create or replace package tbicds.PCK_QUESTIONNAIRES
AUTHID CURRENT_USER 
is
/* Copyright 2016 Intellica Corporation.  

This software is protected by FAR Subpart 27.4 - Rights in Data and Copyrights and 
international treaties.  The software was produced by Intellica Corporation of 
San Antonio, Texas for the Veterans Administration (VA) under Contract Number 
VA118-14-C-0015, Project Number TAC-16-28335 and Project Title, 
'Traumatic Brain Injury Clinical Decision Support (TBI CDS) Implementation'.  
Contract dates: 8 May 2014 - 4 January 2016.  This software was finalized 
and uploaded to the VA's Open Source Electronic Health Record Alliance (OSEHRA) 
on 31 December 2015.  Unauthorized reproduction or distribution of this software 
or any portion of it may result in severe civil and criminal penalties and will 
be prosecuted to the maximum possible extent of the law.

For licensing information contact:  info@intellicacorp.com 
*/
  type RetRefCursor is ref cursor;

  procedure GetModuleRS(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_nMID             in number,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2,
                        rs                  out RetRefCursor);

  procedure GetModuleTopicRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_nMID             in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor);

  procedure GetQuestionRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_nMID             in number,
                          pi_nTID             in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor);

  procedure GetResponseRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_nMID             in number,
                          pi_nTID             in number,
                          pi_nQID             in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor);

  procedure GetSkipPatternRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_nMID             in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor);

  procedure GetMaskRS(pi_vSessionID       in varchar2,
                      pi_vSessionClientIP in varchar2,
                      pi_nUserID          in number,
                      pi_nMID             in number,
                      po_nStatusCode      out number,
                      po_vStatusComment   out varchar2,
                      rs                  out RetRefCursor);

  procedure GetStatData(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_nMID             in number,
                        pi_nTID             in number,
                        pi_nQID             in number,
                        pi_nRID             in number,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2,
                        rs                  out RetRefCursor);
                        
  procedure GetNextModuleRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vPatientID       in varchar2,
                          pi_vSiteID          in varchar2,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor);
                          
  /* gets a new intake_id for the module */
  procedure GetNewIntakeID(pi_vSessionID       in varchar2,
                      pi_vSessionClientIP in varchar2,
                      pi_nUserID          in number,
                      po_nStatusCode      out number,
                      po_vStatusComment   out varchar2,
                      rs                  out RetRefCursor);

end PCK_QUESTIONNAIRES;
/

